/*******************************************************
Filename		:  	DW_result_criteria_geo.sql
Release 		:  	STORET c2.0
SIR			:  	1435, 1437, 1439, 1440, 1441
Description		:  	Creates a centralized form page that allows the user to select 
				all the most common parameters to query Results. This information
				is passed to the DW_result_count procedure.
Author			:  	Joseph Wilson/Christine Tsang
Date			: 	March 3, 2003  --added new CHAR section, commented out proj and org sections
                        	03/12/2003 - Added 3 more date ranges. -C Tsang
				03/18/2003 - Replaced hard-coded date logic with call to DW_DISPLAY_CALENDAR.
						  -C Tsang
				03/24/2003 - Updated table and column names to work with updated ETL. -J Wilson
				04/10/2003 - Set up tabbing sequence.
				04/14/2003 - Reset Date fields with JavaScript. -J Wilson
				04/24/2003 - Expanded Characteristic listbox width. -CT
				04/29/2003 - Generate char alias type list with a table query instead of hardcode. -CT   
				05/01/2003 - Updated submitCriteriaResultGeo() JS function call name. -JW
				05/01/2003 - Updated help link. -BN
                        	05/23/2003 SIR 1442 TIR#2 - Changed wording in date selection box. -CT
                        	06/13/2003 - Removed hardcoded schema (SIR 1483). -CT
				06/19/2003 SIR 1504 - Replaced code for geographic, date range and characteristics selections with 
                                     procedure calls. -CT
				07/22/2003 - Added hidden var "result_type" -JW
                        08/07/2003 SIR 1443 - Added Activity Medium selection. -CT
                        08/15/2003 - Removed 'BETA' from the page title. -CT
                        08/22/2003 -- SIR 1500 TIR#1 - Removed hidden variable D_ORG_LIST. -CT
Comments		:  	Calls three pop-up screens that allow the user to enter additional
				information.
**********************************************************/
SET DEF OFF;

CREATE OR REPLACE PROCEDURE DW_ResultCriteria_GEO AS

/**
--used to generate org list
CURSOR corg IS
SELECT pk_isn, organization_id, organization_name
FROM DI_ORG
order by organization_id;

--used to generate project list
CURSOR cproj IS
SELECT pk_isn, project_cd, project_name
FROM DI_PROJECT
order by identification_cd;
**/

program_path  	varchar2(1000) := null;
script_path   	varchar2(1000) := null;
image_path    	varchar2(1000) := null;
page_title    	varchar2(100)  :='Regular Results by Geographic Location';

BEGIN
DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path,
 'document.forms[1].reset();ChangeOptionDays(''FROM'',1);ChangeOptionDays(''END'',1);adjust_width_n(document.forms[1].D_MEDIUM_LIST,"~","30~","None","Y")');
htp.print('<form action="DW_RESULT_COUNT" method=POST>');

-- Geographic location selection
DW_geo_select;

-- Date range selection 
DW_date_select(15);

-- Activity Medium selection
DW_medium_select(39);

-- Characteristics selection
DW_char_select(40);

/**
-- start of organization module
HTP.PRINT('<BR>
<H4>Organization</H4>
<table width="100%" cols=1 border=1>
<TR>
<TD align="center">
Please select one or more Organization(s)
<br>
<!-- INPUT TYPE="TEXT" READONLY style="font: 10pt/12pt COURIER"  VALUE="ORGANIZATION_NAME                                                  ORG_ID" size="78"  onFocus="javascript:this.blur()" -->
<INPUT TYPE="TEXT" READONLY style="font: 10pt/12pt COURIER"  VALUE="ORG_ID                              ORGANIZATION_NAME" size="78"  onFocus="javascript:this.blur()">
<br>
<font face="Courier">');

	htp.formSelectOpen('D_ORG_LIST', nsize => '10', cattributes => 'tabindex=24 multiple style="font:  10pt/12pt COURIER"');
      htp.formSelectOption('Select All_________________________________________________________________',cselected => 'TRUE', cattributes => 'VALUE="ALL"');
	FOR org IN corg LOOP
        	--htp.formSelectOption(org.organization_name||'~'||org.organization_id, cattributes => 'VALUE='||org.pk_isn);
		htp.formSelectOption(org.organization_id||'~'||org.organization_name, cattributes => 'VALUE='||org.pk_isn);
	END LOOP;

HTP.PRINT('</SELECT>
</font><br><br>
</td>
</TR>
</TABLE>');

-- start of project module
HTP.PRINT('<BR>
<H4>Project</H4>
<table width="100%" cols=1 border=1>
<TR>
<TD align="center">
Please select one or more Project(s)
<br>
<INPUT TYPE="TEXT" READONLY style="font: 10pt/12pt COURIER"  VALUE="PROJ_ID                              PROJECT_NAME" size="78"  onFocus="javascript:this.blur()">
<br>
<font face="Courier">');

	htp.formSelectOpen('D_PROJ_LIST', nsize => '10', cattributes => 'tabindex=25 multiple style="font:  10pt/12pt COURIER"');
      htp.formSelectOption('Select All_________________________________________________________________',cselected => 'TRUE', cattributes => 'VALUE="ALL"');
	FOR proj IN cproj LOOP
        	htp.formSelectOption(proj.identification_cd||'~'||proj.name, cattributes => 'VALUE='||proj.pk_isn);
	END LOOP;

HTP.PRINT('</SELECT>
</font><br><br>
</td>
</TR>
</TABLE>');
**/

htp.print('
<input type="hidden" name="RESULT_TYPE" value="REGULAR">
<br>
<center>
<input type="button" value="Continue" tabindex=46 onclick="javascript: submitCriteriaResultGeo();" title="Submit Selection Criteria for processing">&nbsp&nbsp&nbsp
<input type="button" value="Clear Form" tabindex=47 onclick="javascript: deleteAllFromCharList();document.forms[1].reset();ChangeOptionDays(''FROM'',1);ChangeOptionDays(''END'',1);" title="Clear the form">
</center></form>
');
DW_bottom_of_page(21);

END;
/
SHOW ERRORS;
